/*
 *
 *  $Id: pvrusb2-video.h,v 1.1 2005/11/14 13:31:24 mchehab Exp $
 *
 *  Copyright (C) 2005 Mike Isely <isely@pobox.com>
 *  Copyright (C) 2004 Aurelien Alleaume <slts@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __PVRUSB2_VIDEO_H
#define __PVRUSB2_VIDEO_H

/*

   This module connects the pvrusb2 driver to the I2C chip level
   driver which handles device video processing.  This interface is
   used internally by the driver; higher level code should only
   interact through the interface provided by pvrusb2-hdw.h.

*/

struct pvr2_hdw;

int pvr2_decoder_set_norm(struct pvr2_hdw *);
int pvr2_decoder_set_input(struct pvr2_hdw *);
int pvr2_decoder_set_size(struct pvr2_hdw *);
int pvr2_decoder_set_audio(struct pvr2_hdw *);
int pvr2_decoder_set_bcsh(struct pvr2_hdw *);
int pvr2_decoder_is_tuned(struct pvr2_hdw *);
int pvr2_decoder_enable_output(struct pvr2_hdw *,int);

#endif /* __PVRUSB2_VIDEO_H */

/*
  Stuff for Emacs to see, in order to encourage consistent editing style:
  *** Local Variables: ***
  *** mode: c ***
  *** fill-column: 70 ***
  *** tab-width: 8 ***
  *** c-basic-offset: 8 ***
  *** End: ***
  */
