#!/bin/sh

PWD=`pwd`
CWD=$PWD

cd ../linux
V4L=$PWD
cd ../../dvb-kernel/linux
DVB=$PWD

for x in `find drivers/media/dvb -type d | grep -v CVS | grep -v patches | grep -v compat` ; do
	mkdir -p -v $V4L/$x
done

echo creating symbolic links...

mkdir -p -v $V4L/include/linux/dvb

for x in `find drivers -type f | grep -v CVS | grep -v .cvsignore` ; do
	ln -f -s $DVB/$x $V4L/$x
done

for x in `find include -type f | grep -v CVS | grep -v .cvsignore` ; do
	ln -f -s $DVB/$x $V4L/$x
done

cd $CWD
patch -p2 <<'DIFF'
diff -up v4l-kernel.orig/v4l/Make.config v4l-kernel/v4l/Make.config
--- v4l-kernel.orig/v4l/Make.config	2005-10-08 17:31:57.000000000 -0400
+++ v4l-kernel/v4l/Make.config	2005-10-08 17:46:08.000000000 -0400
@@ -32,5 +32,7 @@ endif
 ifeq ($(CONFIG_VIDEO_BUF_DVB),m)
  CONFIG_VIDEO_CX88_DVB	:= m
  CONFIG_VIDEO_SAA7134_DVB := m
+ CONFIG_DVB_BT8XX       := m
+ CONFIG_DVB_FRONTENDS    := m
 endif
 
diff -up v4l-kernel.orig/v4l/Makefile v4l-kernel/v4l/Makefile
--- v4l-kernel.orig/v4l/Makefile	2005-10-08 17:31:57.000000000 -0400
+++ v4l-kernel/v4l/Makefile	2005-10-08 17:45:48.000000000 -0400
@@ -69,6 +69,7 @@ ifeq ($(VERSION).$(PATCHLEVEL),2.6)
 endif
 
 # for DVB
+EXTRA_CFLAGS += -DDVB_CVS=1
 EXTRA_CFLAGS += -I$(srctree)/drivers/media/dvb/dvb-core/
 EXTRA_CFLAGS += -I$(srctree)/drivers/media/dvb/frontends/
 ifeq ($(CONFIG_VIDEO_CX88_DVB),m)
@@ -173,7 +174,7 @@ export LC_ALL
 default:: links .version
 	$(MAKE) -C $(KDIR) SUBDIRS=$(PWD) $(MYCFLAGS) modules
 
-links::
+links:: dvb-links
 	@echo creating symbolic links...
 	@find ../linux/drivers/media/video -name '*.[c,h]' -type f -exec ln -sf '{}' . \;
 
@@ -185,7 +186,7 @@ links::
 	@find ../linux/drivers/media/dvb/frontends -name '*.[c,h]' -type l -exec ln -sf '{}' . \;
 	@find ../linux/drivers/media/dvb/bt8xx -name '*.[c,h]' -type l -exec ln -sf '{}' . \;
 
-install:: rminstall
+install:: rminstall dvb-install
 	@echo -e "\nInstalling new V4L modules at corresponding Kernel dir..."
 
 	@strip --strip-debug $(inst-m)
@@ -251,7 +252,7 @@ dvb-rminstall::
 		$(addprefix $(KDIR26)/dvb/frontends/, $(addsuffix .gz,$(inst_frontends))) 2>/dev/null
 	@echo
 
-rminstall::
+rminstall:: dvb-rminstall
 	@echo -e "\nEliminating old V4L modules (errors on this step is not a problem).."
 
 	-@rm -r $(DEST) \
@@ -274,7 +275,7 @@ rminstall::
 rmmodules::
 	rmmod -w $(shell echo "$(v4l_modules)"|sed s,' ','\n',g|sed s,'-','_',g|sort|uniq -d)
 
-clean::
+clean:: unmerge-trees
 	find . -name '*.c' -type l -exec rm '{}' \;
 	find . -name '*.h' -type l -exec rm '{}' \;
 	-rm -f *~ *.o *.ko *.mod.c
